/*:
 * @target MZ
 * @plugindesc Fixes follower desync issues after map transfers by correctly resetting their positions.
 * @author Clay Davis
 * 
 * @help This plugin ensures that followers correctly sync to the player's position 
 * when transferring to a new map, avoiding issues where they appear on the wrong side of the screen.
 * 
 * No plugin commands are required. Just install and enable it.
 */

(() => {
    const _Game_Player_performTransfer = Game_Player.prototype.performTransfer;

    Game_Player.prototype.performTransfer = function () {
        _Game_Player_performTransfer.call(this);  // Call the original transfer behavior

        if (this.isTransferring()) {
            return;
        }

        // Sync follower positions manually after transfer
        this.fixFollowerPositions();
        this.refresh();  // Ensure correct positioning
    };

    Game_Player.prototype.fixFollowerPositions = function () {
        // Use visibleFollowers() to access all visible followers and reset their positions
        this._followers.visibleFollowers().forEach(follower => {
            follower.setPosition(this.x, this.y);
        });
    };

    const _Game_Map_setup = Game_Map.prototype.setup;
    Game_Map.prototype.setup = function (mapId) {
        _Game_Map_setup.call(this, mapId);
        $gamePlayer.fixFollowerPositions();  // Ensure sync during map setup
    };
})();